/*------------------------------------------------------------------------------*
 *	File Name: 	ocMorph.h	   													*
 *	Purpose:	Image morphological operations, using contours					*
 *				This header is shared between OC and VC							*
 *																				*
 *	Author:		CPY																*
 *  Creation:	1/19/2004 														*
 *  	Copyright (c) OriginLab, Corp. 2004										*
 -------------------------------------------------------------------------------*/

#ifndef	_OC_MORPH_H
#define	_OC_MORPH_H

#ifdef __AFX_H__
	#ifdef OCCONTOUR_DLL
		#define OCCONTOUR_API __declspec(dllexport)
	#else
		#define OCCONTOUR_API __declspec(dllimport)
	#endif
	#define TreeNode  OCXmlWrapperBase
	#define uint UINT
	extern "C" {
#else
	#define OCCONTOUR_API
	#pragma dll(ocContour)	// Assoicate all functions below to OCcontour.dll which must be in the Origin EXE folder
#endif	//__AFX_H__

#define GRIDVAL float  // not able to get GRIDVAL to be short

typedef struct tagContourSelection
{
	int		minPts;
	int		maxPts;
	float 	minArea;
	float	maxArea;
	float	minRoundness;
	float	maxRoundness;
	float	minEllipseRatio;
	float	maxEllipseRatio;
	int		minSmoothedSegmentPts;
	int		nCurvatureStepPts;
	float	maxSegmentMinSD;  // curvature measured in segment, smoothed region will yield small SD
	float	minIntensitySD;// intensity distribution of area covered by contour, use this to indicate some features must existed
	int		nPeakValley; // = 0 if no test, 1 if interior intensity at least 1 higher then contour, -1 if at least -1 less then contour
} ContourSelection;
// dwParam
enum {
	FC_CONSOLIDATE = 0x01
};

/**#$
*/
OCCONTOUR_API int find_contours(GRIDVAL* pgVal, int ngVals, GRIDVAL* lpData, int nRows, int nCols, TreeNode* pTreeNode, ContourSelection* pSelParams, DWORD dwParam);
/**#$
*/
OCCONTOUR_API GRIDVAL find_level_with_most_objects(GRIDVAL fMin, GRIDVAL fMax, GRIDVAL* lpData, int nRows, int nCols, ContourSelection* pSelParams, int nLevels);


//------- CPY 7/10/04 CONTOUR_SHAPE_BASIC_CHARACTERISTICS
/**#$
	polygon	analysis to determine the complexity
	Parameters:
		px = array of floats with X coordinates
		py = array of floats with Y coordinates
		nSize = size of the px py arrays
		pComplexity = a complexity measure, see Remarks
		pDistMin = the min length of the distances between opposite points
		pDistMax = the max length of the distnaces between opposite points
		pMinDistADM = the distances variations(average diviation from DistMin) measured near the min location
		pnMin = the index in the polygon with min distance, can be NULL 
		pnMax = the index in the polygon with max distance, can be NULL
		nSGpts = number of points on left and right for the Savitsky-Golay smoothing
	Return:
		FALSE if calculation failed, usually due to polygon having too few points
	Remarks:
		We first calculate the distances between opposite points in the polygon. Opposite points are taken as the mid point when going through all the
		other points in the polygon from the current point. This distances array is then smoothed using Savitsky-Golay to generate a second array which
		prepresent the smoothed out distance curve. We then make a third array as the diviation of the original distance from the smoothed ones.
		The complexity is the ratio between the average diviation and the average distance.
*/
OCCONTOUR_API BOOL polygon_complexity(const float *px, const float *py, uint nSize, double* pComplexity, double *pDistMin, double* pDistMax, double* pMinDistADM = NULL, uint* pnMin = NULL, uint* pnMax = NULL, int nSGpts = 2);

OCCONTOUR_API BOOL contour_curvatures(const float *px, const float *py, double* pCuvs, uint nSize, BOOL bAbs = true, int nMinRange= 2, int nMaxRange = 4);

OCCONTOUR_API double contour_curvature_min_SD(const float *px, const float *py, uint nSize, uint nCuvStep, uint nSegmentSize, uint nSegmentInc);

OCCONTOUR_API double contour_intensity_SD(const float* pMat, uint nRow, uint nCols, const FLOATRECT* pBox, double dRatio = 0.75, double* pMean = NULL); 	

OCCONTOUR_API BOOL contour_short_long_axis(const float *px, const float *py, uint nSize, double *pDistMin, double* pDistMax = NULL, uint* pnMin = NULL, uint* pnMax = NULL);
//-------
#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OC_MORPH_H
